package Requirements;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;


public class TrafficControlCenter implements ActionListener
{
    public TrafficLightCluster[] clusters;
    public int selectedCluster;
    public boolean loggedIn;
    public GUI gui;
    
    
    /*
     * Program entry point
    */
    public static void main(String[] args)
    {
	// GUI Look and feel
	try{
	    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	} catch (Exception e) { }
	
	// Create an instance of our traffic control center
	TrafficControlCenter tcc = new TrafficControlCenter();
	
	// hard-code a 4-way light cluster
	TrafficLightCluster tlc = new TrafficLightCluster();
	try {
	    // Add North+South lights
	    tlc.SetGroup1(
		    new Light(tcc.gui.NorthText), new Light(tcc.gui.SouthText));
	    // Add East+West lights
	    tlc.SetGroup2(
		    new Light(tcc.gui.WestText), new Light(tcc.gui.EastText));
	} catch (Exception e) {
	    System.err.println(e);
	}
	
	// Add the tcl to the control center, and set it as the selected cluster
	tcc.clusters = new TrafficLightCluster[1];
	tcc.clusters[0] = tlc;
	tcc.SelectCluster(0);
	// Login to our light cluster
	tcc.ClusterLogin("name","pass");
    }

    /*
     * Constructor
    */
    public TrafficControlCenter()
    {
	loggedIn = false;
	// Setup GUI
	gui = new GUI();
	gui.setVisible(true);
	// Attach listeners to GUI components
	gui.StartButton.addActionListener(this);
	gui.StopButton.addActionListener(this);
    }

    /*
     * Select a light cluster
    */
    public void SelectCluster(int index)
    {
	if (clusters != null && clusters.length < index)
	    selectedCluster = index;
    }
    
    /*
     * Get the selected light cluster
    */
    public TrafficLightCluster SelectedCluster()
    {
	if (clusters != null && clusters.length > selectedCluster)
	    if (clusters[selectedCluster] != null)
		return clusters[selectedCluster];
	return null;
    }

    /*
     * Log into the selected light cluster
    */
    public void ClusterLogin(String name, String pass)
    {
	if (SelectedCluster() != null)
	{
	    if (SelectedCluster().Login(name,pass))
	    {
		loggedIn = true;
		return;
	    }
	}
	loggedIn = false;
    }
    
    /*
     * Log out of the selected light cluster
    */
    public void ClusterLogout()
    {
	if (loggedIn)
	{
	    SelectedCluster().Logout();
	    loggedIn = false;
	}
    }
    
    /*
     * This will create a light schedule timer based on an int
     * (the selected index from the GUI dropdown box) for the selected 
     * light cluster.
    */
    public void CreateClusterTimer(int type) throws Exception
    {
	if (loggedIn)
	{
	    // n/s: normal, e/w: normal
	    if (type == 0)
		SelectedCluster().CreateTimer(ScheduleType.NORMAL,ScheduleType.NORMAL);
	    // n/s: blinkred, e/w: blinkred
	    else if (type == 1)
		SelectedCluster().CreateTimer(ScheduleType.BLINKRED,ScheduleType.BLINKRED);
	    // n/s: blinkyellow, e/w: blinkred
	    else if (type == 2)
		SelectedCluster().CreateTimer(ScheduleType.BLINKYELLOW,ScheduleType.BLINKRED);
	    // n/s: blinkred, e/w: blinkyellow
	    else if (type == 3)
		SelectedCluster().CreateTimer(ScheduleType.BLINKRED,ScheduleType.BLINKYELLOW);
	    else
		throw new Exception("parameter must be a number between 0 and 3");
	}
    }
    
    /*
     * Enable the light schedule for our selected light cluster
    */
    public void EnableClusterLights()
    {
	if (loggedIn)
	    SelectedCluster().EnableLights();
    }
    
    /*
     * Disable the light schedule for our selected light cluster
    */
    public void DisableClusterLights()
    {
	if (loggedIn)
	    SelectedCluster().DisableLights();
    }
    
    /*
     * Listen for mouse events on the GUI buttons to start/stop
    */
    public void actionPerformed(ActionEvent ae)
    {
	JButton button = (JButton)ae.getSource();
	
	// Create the specified light schedule, and start it
	if (button.getName() == "StartButton")
	{
	    try {
		CreateClusterTimer(gui.ScheduleSelector.getSelectedIndex());
		EnableClusterLights();
	    } catch (Exception e) {
		System.err.println(e);
	    }
	}
	// Stop any light schedules
	else
	{
	    DisableClusterLights();
	}
    }
    
}